/*
 * Decompiled with CFR 0.152.
 */
package com.trontheim.expstore.block.tileentity;

import com.google.gson.Gson;
import com.trontheim.expstore.init.ESBlocks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class TileEntityExpStore
extends TileEntity {
    private ExperienceStorage experienceStorage = new ExperienceStorage();

    public boolean storeExperiencePoints(EntityPlayer player) {
        if (0 == player.field_71067_cb) {
            return false;
        }
        Integer amount = player.field_71067_cb;
        if (!this.experienceStorage.addExperiencePoints(player, amount)) {
            return false;
        }
        player.func_82242_a(-(player.field_71068_ca + 1));
        player.func_146105_b((IChatComponent)new ChatComponentText("experience points stored: " + amount.toString()));
        return true;
    }

    public boolean restoreExperiencePoints(EntityPlayer player) {
        if (0 == this.experienceStorage.getExperiencePoints(player)) {
            return false;
        }
        Integer amount = this.experienceStorage.getExperiencePoints(player);
        if (!this.experienceStorage.addExperiencePoints(player, -amount.intValue())) {
            return false;
        }
        player.func_71023_q(amount.intValue());
        player.func_146105_b((IChatComponent)new ChatComponentText("experience points restored: " + amount.toString()));
        return true;
    }

    public boolean resetStore(EntityPlayer player) {
        this.experienceStorage.reset();
        player.func_146105_b((IChatComponent)new ChatComponentText("all stored experience points deleted."));
        return true;
    }

    public Integer getSoredExperiencePoints(EntityPlayer player) {
        return this.experienceStorage.getExperiencePoints(player);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagCompound data = compound.func_74775_l("expstore:storage");
        if (compound.func_74764_b("expstore:TileEntityExpStore")) {
            ExperienceStorage oldData = (ExperienceStorage)new Gson().fromJson(compound.func_74779_i("expstore:TileEntityExpStore"), ExperienceStorage.class);
            data = oldData.exportData();
        }
        this.experienceStorage.importData(data);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74782_a("expstore:storage", (NBTBase)this.experienceStorage.exportData());
        if (compound.func_74764_b("expstore:TileEntityExpStore")) {
            compound.func_82580_o("expstore:TileEntityExpStore");
        }
    }

    private static class ExperienceStorage {
        private HashMap<String, Integer> experience = new HashMap();

        private ExperienceStorage() {
        }

        private boolean reset() {
            this.experience = new HashMap();
            return true;
        }

        private String getUUID(EntityPlayer player) {
            return ESBlocks.isDevelopmentEnvironment() ? "DEVPLAYER" : player.func_110124_au().toString();
        }

        private boolean addExperiencePoints(EntityPlayer player, Integer amount) {
            String uuid = this.getUUID(player);
            if (!this.experience.containsKey(uuid)) {
                this.experience.put(uuid, 0);
            }
            Integer currentAmount = this.experience.get(uuid);
            int maxAmount = Integer.MAX_VALUE - currentAmount;
            if (amount > maxAmount) {
                amount = maxAmount;
            }
            int minAmount = Integer.MIN_VALUE + currentAmount;
            if (amount < minAmount) {
                amount = minAmount;
            }
            if ((currentAmount = Integer.valueOf(currentAmount + amount)) < 0) {
                currentAmount = 0;
            }
            this.experience.put(uuid, currentAmount);
            return true;
        }

        private Integer getExperiencePoints(EntityPlayer player) {
            String uuid = this.getUUID(player);
            return this.experience.containsKey(uuid) ? this.experience.get(uuid) : 0;
        }

        private NBTTagCompound exportData() {
            NBTTagCompound data = new NBTTagCompound();
            for (Map.Entry<String, Integer> entry : this.experience.entrySet()) {
                data.func_74768_a(entry.getKey(), entry.getValue().intValue());
            }
            return data;
        }

        private void importData(NBTTagCompound data) {
            this.reset();
            for (Object key : data.func_150296_c()) {
                this.experience.put(key.toString(), data.func_74762_e(key.toString()));
            }
        }
    }
}

