/*
 * Decompiled with CFR 0.152.
 */
package com.trontheim.expstore.client.gui;

import com.trontheim.expstore.block.tileentity.TileEntityExpStore;
import com.trontheim.expstore.network.PacketHandler;
import com.trontheim.expstore.network.packet.ExperienceMessage;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiClientExpStore
extends GuiScreen {
    private static final ResourceLocation backgroundLocation = new ResourceLocation("expstore", "textures/gui/background.png");
    private static final ResourceLocation logoLocation = new ResourceLocation("expstore", "textures/gui/logo.png");
    private EntityPlayer player;
    private TileEntityExpStore tileEntity;
    private int xSize = 248;
    private int ySize = 166;
    private int guiLeft;
    private int guiTop;
    private GuiButton buttonStore;
    private GuiButton buttonRestore;

    public GuiClientExpStore(EntityPlayer player, World world, int x, int y, int z) {
        this.player = player;
        this.tileEntity = GuiClientExpStore.getTileEntity(world, x, y, z);
    }

    private static TileEntityExpStore getTileEntity(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityExpStore)) {
            return null;
        }
        return (TileEntityExpStore)tileEntity;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        this.drawGuiBackgroundLayer(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.drawGuiForegroundLayer(mouseX, mouseY);
        GL11.glPopMatrix();
    }

    protected void drawGuiBackgroundLayer(int mouseX, int mouseY, float partialTicks) {
        this.field_146297_k.func_110434_K().func_110577_a(backgroundLocation);
        this.func_73729_b((this.field_146294_l - this.xSize) / 2, (this.field_146295_m - this.ySize) / 2, 0, 0, this.xSize, this.ySize);
    }

    protected void drawGuiForegroundLayer(int mouseX, int mouseY) {
        Experience experienceStore = new Experience(this.tileEntity.getSoredExperiencePoints(this.player));
        Experience experiencePlayer = new Experience(this.player.field_71067_cb);
        GL11.glPushMatrix();
        float scale = 0.125f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_146297_k.func_110434_K().func_110577_a(logoLocation);
        this.func_73729_b(40, 40, 0, 0, 256, 256);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)1.2f, (float)1.2f, (float)1.2f);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tile.expstore.expstore.gui.heading", (Object[])new Object[0]), 32, 16, 0x404040);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tile.expstore.expstore.gui.player", (Object[])new Object[0]) + ": " + experiencePlayer.experienceTotal.toString(), 8, 40, 0x404040);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)10.0f, (float)60.0f, (float)0.0f);
        this.renderXpBar(experiencePlayer);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tile.expstore.expstore.gui.store", (Object[])new Object[0]) + ": " + experienceStore.experienceTotal.toString(), 8, 70, 0x404040);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)10.0f, (float)90.0f, (float)0.0f);
        this.renderXpBar(experienceStore);
        GL11.glPopMatrix();
    }

    private void renderXpBar(Experience exp) {
        this.field_146297_k.func_110434_K().func_110577_a(Gui.field_110324_m);
        int j1 = exp.xpBarCap();
        int width = 182;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (j1 > 0) {
            int l1 = (int)(exp.experience.floatValue() * (float)(width + 1));
            this.func_73729_b(0, 0, 0, 64, width, 5);
            if (l1 > 0) {
                this.func_73729_b(0, 0, 0, 69, l1, 5);
            }
        }
        if (exp.experienceLevel > 0) {
            int x = (width - this.field_146289_q.func_78256_a(exp.experienceLevel.toString())) / 2;
            int y = -6;
            this.field_146289_q.func_78276_b(exp.experienceLevel.toString(), x + 1, y, 0);
            this.field_146289_q.func_78276_b(exp.experienceLevel.toString(), x - 1, y, 0);
            this.field_146289_q.func_78276_b(exp.experienceLevel.toString(), x, y + 1, 0);
            this.field_146289_q.func_78276_b(exp.experienceLevel.toString(), x, y - 1, 0);
            this.field_146289_q.func_78276_b(exp.experienceLevel.toString(), x, y, 8453920);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.equals(this.buttonStore)) {
            PacketHandler.sendToServer(new ExperienceMessage(ExperienceMessage.MODE.STORE, this.tileEntity));
        }
        if (button.equals(this.buttonRestore)) {
            PacketHandler.sendToServer(new ExperienceMessage(ExperienceMessage.MODE.RESTORE, this.tileEntity));
        }
    }

    public void func_73876_c() {
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonStore.field_146124_l = true;
        this.buttonRestore.field_146124_l = true;
        if (this.player.field_71067_cb == 0) {
            this.buttonStore.field_146124_l = false;
        }
        if (this.tileEntity.getSoredExperiencePoints(this.player) == 0) {
            this.buttonRestore.field_146124_l = false;
        }
    }

    public void func_73866_w_() {
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.buttonStore = new GuiButton(0, this.guiLeft + 10, this.guiTop + this.ySize - 30, this.xSize / 2 - 20, 20, "Store");
        this.field_146292_n.add(this.buttonStore);
        this.buttonRestore = new GuiButton(0, this.guiLeft + 10 + this.xSize / 2, this.guiTop + this.ySize - 30, this.xSize / 2 - 20, 20, "Restore");
        this.field_146292_n.add(this.buttonRestore);
        this.updateButtons();
    }

    public boolean func_73868_f() {
        return false;
    }

    protected class Experience {
        Integer experienceTotal = 0;
        Float experience = Float.valueOf(0.0f);
        Integer experienceLevel = 0;

        Experience(int experience) {
            this.setExperience(experience);
        }

        void setExperience(int experience) {
            this.experienceTotal = experience;
            this.calculate();
        }

        private void calculate() {
            this.experience = Float.valueOf(this.experience.floatValue() + (float)this.experienceTotal.intValue() / (float)this.xpBarCap());
            while (this.experience.floatValue() >= 1.0f) {
                this.experience = Float.valueOf((this.experience.floatValue() - 1.0f) * (float)this.xpBarCap());
                Integer n = this.experienceLevel;
                Integer n2 = this.experienceLevel = Integer.valueOf(this.experienceLevel + 1);
                this.experience = Float.valueOf(this.experience.floatValue() / (float)this.xpBarCap());
            }
        }

        int xpBarCap() {
            return this.experienceLevel >= 30 ? 62 + (this.experienceLevel - 30) * 7 : (this.experienceLevel >= 15 ? 17 + (this.experienceLevel - 15) * 3 : 17);
        }
    }
}

