/*
 * Decompiled with CFR 0.152.
 */
package com.trontheim.expstore.client.renderer.block;

import com.trontheim.expstore.block.BlockExpStore;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;

public class RenderBlockExpStore
implements ISimpleBlockRenderingHandler {
    private static RenderBlockExpStore instance = new RenderBlockExpStore();
    private int width = 16;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float offsetZ = 0.0f;
    private int renderId = RenderingRegistry.getNextAvailableRenderId();

    private RenderBlockExpStore() {
    }

    public static RenderBlockExpStore instance() {
        return instance;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        this.renderInventoryBlock((BlockExpStore)block, metadata, modelId, renderer);
    }

    public void renderInventoryBlock(BlockExpStore block, int metadata, int modelId, RenderBlocks renderer) {
        this.renderBlockMetadata(block, 0, 0, 0, metadata, true, renderer);
    }

    public boolean renderBlockMetadata(BlockExpStore block, int x, int y, int z, int metadata, boolean isItem, RenderBlocks renderer) {
        if (isItem) {
            RenderManager.field_78727_a.field_78721_f.renderItem((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, new ItemStack(Item.func_150898_a((Block)block), 1, 0), 0, IItemRenderer.ItemRenderType.INVENTORY);
        } else {
            this.setColor(renderer.field_147845_a, x, y, z, block);
            this.setRenderOrigin(2, 0, 2);
            this.addRenderBox(renderer, 1.0f, 1.0f, 1.0f, 10.0f, 12.0f, 10.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 11.0f, 1.0f, 0.0f, 1.0f, 12.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 11.0f, 1.0f, 11.0f, 1.0f, 12.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 0.0f, 1.0f, 0.0f, 1.0f, 12.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 0.0f, 1.0f, 11.0f, 1.0f, 12.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 0.0f, 0.0f, 0.0f, 12.0f, 1.0f, 12.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 0.0f, 13.0f, 0.0f, 12.0f, 1.0f, 12.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 2.0f, 14.0f, 2.0f, 8.0f, 1.0f, 8.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 2.0f, 14.0f, 1.0f, 8.0f, 1.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 2.0f, 14.0f, 10.0f, 8.0f, 1.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 10.0f, 14.0f, 2.0f, 1.0f, 1.0f, 8.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 1.0f, 14.0f, 2.0f, 1.0f, 1.0f, 8.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 3.0f, 15.0f, 3.0f, 6.0f, 1.0f, 6.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 3.0f, 15.0f, 2.0f, 6.0f, 1.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 3.0f, 15.0f, 9.0f, 6.0f, 1.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 9.0f, 15.0f, 3.0f, 1.0f, 1.0f, 6.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 2.0f, 15.0f, 3.0f, 1.0f, 1.0f, 6.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 4.0f, 5.0f, 0.0f, 4.0f, 4.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 5.0f, 9.0f, 0.0f, 2.0f, 1.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 5.0f, 4.0f, 0.0f, 2.0f, 1.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 8.0f, 6.0f, 0.0f, 1.0f, 2.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
            this.addRenderBox(renderer, 3.0f, 6.0f, 0.0f, 1.0f, 2.0f, 1.0f);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        renderer.func_147771_a();
        return true;
    }

    private void setColor(IBlockAccess world, int x, int y, int z, BlockExpStore block) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        int color = block.func_149720_d(world, x, y, z);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float redAnaglyph = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
            float greenAnaglyph = (red * 30.0f + green * 70.0f) / 100.0f;
            float blueAnaglyph = (red * 30.0f + green * 70.0f) / 100.0f;
            red = redAnaglyph;
            green = greenAnaglyph;
            blue = blueAnaglyph;
        }
        tessellator.func_78386_a(red, green, blue);
    }

    private void setRenderOrigin(int x, int y, int z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    private void addRenderBox(RenderBlocks renderer, float x, float y, float z, float width, float height, float depth) {
        float pixel = 1.0f / (float)this.width;
        x = (this.offsetX + x) * pixel;
        y = (this.offsetY + y) * pixel;
        z = (this.offsetZ + z) * pixel;
        width = x + width * pixel;
        height = y + height * pixel;
        depth = z + depth * pixel;
        renderer.func_147782_a((double)x, (double)y, (double)z, (double)width, (double)height, (double)depth);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return this.renderWorldBlock(world, x, y, z, (BlockExpStore)block, modelId, renderer);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return this.renderId;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockExpStore block, int modelId, RenderBlocks renderer) {
        return this.renderBlockMetadata(block, x, y, z, world.func_72805_g(x, y, z), false, renderer);
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

