/*
 * Decompiled with CFR 0.152.
 */
package com.trontheim.expstore.network.packet;

import com.trontheim.expstore.block.tileentity.TileEntityExpStore;
import com.trontheim.expstore.network.packet.AbstractBiDirectionalMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class ExperienceMessage
implements IMessage {
    int mode;
    int serverX;
    int serverY;
    int serverZ;

    public ExperienceMessage() {
    }

    public ExperienceMessage(MODE mode, TileEntityExpStore tileEntity) {
        this.mode = mode.ordinal();
        this.serverX = tileEntity.field_145851_c;
        this.serverY = tileEntity.field_145848_d;
        this.serverZ = tileEntity.field_145849_e;
    }

    public ExperienceMessage(int mode, TileEntityExpStore tileEntity) {
        this.mode = mode;
        this.serverX = tileEntity.field_145851_c;
        this.serverY = tileEntity.field_145848_d;
        this.serverZ = tileEntity.field_145849_e;
    }

    public void fromBytes(ByteBuf buffer) {
        this.mode = buffer.readInt();
        this.serverX = buffer.readInt();
        this.serverY = buffer.readInt();
        this.serverZ = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.mode);
        buffer.writeInt(this.serverX);
        buffer.writeInt(this.serverY);
        buffer.writeInt(this.serverZ);
    }

    public static class Handler
    extends AbstractBiDirectionalMessageHandler<ExperienceMessage> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, ExperienceMessage message, MessageContext ctx) {
            return this.handleMessage(player, message, ctx);
        }

        @Override
        public IMessage handleServerMessage(EntityPlayer player, ExperienceMessage message, MessageContext ctx) {
            return this.handleMessage(player, message, ctx);
        }

        private IMessage handleMessage(EntityPlayer player, ExperienceMessage message, MessageContext ctx) {
            TileEntityExpStore tileEntity = (TileEntityExpStore)player.field_70170_p.func_147438_o(message.serverX, message.serverY, message.serverZ);
            if (message.mode == MODE.STORE.ordinal()) {
                tileEntity.storeExperiencePoints(player);
            } else if (message.mode == MODE.RESTORE.ordinal()) {
                tileEntity.restoreExperiencePoints(player);
            }
            player.field_70170_p.func_147455_a(message.serverX, message.serverY, message.serverZ, (TileEntity)tileEntity);
            if (ctx.side == Side.SERVER) {
                return new ExperienceMessage(message.mode, tileEntity);
            }
            return null;
        }
    }

    public static enum MODE {
        STORE,
        RESTORE;

    }
}

